*	ZIK DRIVER IN TIMER A  (50 HZ)    V1.2
*		POUR FALCON
*			16-BITS 
*				4 VOIES SUR 2 PISTES STEREO
*					BY AXEL F. OF MCS

	OPT	O-
COLOR	EQU	0	* 0 = COLOR CPU	             1 = NO EFFECT
SAVE	EQU	0	* 0 = POUR TESTER L'ECOUTE   1 = POUR SAUVGARDER 
FREQU	EQU	49170	* 12292  16490  20770  24585  33880  49170  HZ
			*         16,5   19,2   23,3   30,1   42,1   % CPU TAKEN
			*                              26,2   35

	IFNE	FREQU=12292
VAL	EQU	251
	ENDC
	IFNE	FREQU=16490
VAL	EQU	335
	ENDC
	IFNE	FREQU=20770
VAL	EQU	405
	ENDC
	IFNE	FREQU=24585
VAL	EQU	502
	ENDC
	IFNE	FREQU=33880
VAL	EQU	670
	ENDC
	IFNE	FREQU=49170
VAL	EQU	1004
	ENDC

	IFNE SAVE
 lea text,a0
 move.l a0,a5
 lea endtext,a1
 move.l a1,d0
 sub.l a0,d0
 move.l d0,d5
 clr.w -(sp)
 pea filename
 move.W #$3c,-(sp)
 trap #1
 add.l #8,sp
 move.w d0,d3
 move.l a5,-(sp)
 move.l d5,-(sp)
 move.w d3,-(sp)
 move.w #$40,-(sp)
 trap #1
 add.l #12,sp
 move.w d3,-(sp)
 move.w #$3e,-(sp)
 trap #1
 addq.l #4,sp
 clr.l -(sp)
 trap #1 
filename:
 dc.B 'TRUC25.mcs',0
	even

	ELSE

***************************************************************************
	MOVE.W	#$20,-(A7)
	TRAP	#1
	MOVEQ	#0,D0
	JSR 	ZIK
	MOVE.L	#ZIK+4,$134.W
	BCLR.B	#0,$484.W
		
AZE	MOVE.W	#7,-(A7)
	TRAP	#1
	ADDQ.W	#2,A7
	CMP.B	#' ',D0
	BEQ.S	FIN
	CMP.B	#'A',D0
	BEQ.S	SON1
	CMP.B	#'Z',D0
	BEQ.S	SON2
	CMP.B	#'E',D0
	BEQ.S	SON3
	BRA.S	AZE
	
SON1	MOVE.L	#$19050000,D0			* LIGNE SOUNDTRACK
	MOVE.L	#1,D1				* VOIE	(0-3)
	JSR	ZIK+12
	BRA.S	AZE
	
SON2	MOVE.L	#$15050000,D0
	MOVE.L	#0,D1
	JSR	ZIK+12
	BRA.S	AZE

SON3	MOVE.L	#$15040000,D0
	MOVE.L	#2,D1
	JSR	ZIK+12
	MOVE.L	#$15020000,D0
	MOVE.L	#1,D1
	JSR	ZIK+12
	BRA.S	AZE
	
FIN	JSR	ZIK+8
	BSET.B	#0,$484.W
	MOVE.L	#0,-(A7)
	TRAP	#1
	ENDC
ZIK	
text
*****************   MUSIC PLAYER  *************************************
	BRA	INIT
	BRA	VBL
	BRA	END
	BRA	BRUIT
	IFNE	FREQU=12292
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 12 KHZ"
	ENDC
	IFNE	FREQU=16490
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 16 KHZ"
	ENDC
	IFNE	FREQU=20770
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 20 KHZ"
	ENDC
	IFNE	FREQU=24585
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 25 KHZ"
	ENDC
	IFNE	FREQU=33880
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 33 KHZ"
	ENDC
	IFNE	FREQU=49170
	DC.B	"FIRST AXEL F.(MCS)'S MUSIC DRIVER FOR FALCON : 16-BIT 50 KHZ"
	ENDC
	EVEN
******************  SYNCHRONISATION DU DAC  ***************************
******************         A 50 HZ          ***************************
SYNC_DAC
	MOVEM.L	A0-A2/D0,-(A7)
	LEA	DEB_BUF(PC),A2
	MOVE.L	4(A2),A0
	MOVE.L	A0,A1
	ADD.W	#VAL*4,A1			*ADD.W	D0,A1
	PEA	(A1)
	PEA	(A0)
	BCLR	#7,$FFFF8901.W
	CLR.W	D0
	MOVE.B	3(A7),D0
	MOVE.W	D0,$FFFF8906
	MOVE.B	2(A7),D0
	MOVE.W	D0,$FFFF8904
	MOVE.B	1(A7),D0
	MOVE.W	D0,$FFFF8902
	MOVE.B	7(A7),D0
	MOVE.W	D0,$FFFF8912
	MOVE.B	6(A7),D0
	MOVE.W	D0,$FFFF8910
	MOVE.B	5(A7),D0
	MOVE.W	D0,$FFFF890E
	ADDQ.W	#8,A7
	MOVEM.L (A2),A0-A1
	EXG.L	A1,A0
	MOVEM.L A0-A1,(A2)
	MOVEM.L	(A7)+,A0-A2/D0
	RTS
****************  GESTION DU SON ET DES PATTERNES  **********************
****************            A 50 HZ                **********************
VBL
	IFEQ	COLOR
	NOT.W	$FFFF8240.W
	ENDC

	BSR	SYNC_DAC
	MOVE.W	#$2300,SR
	MOVEM.L	D0-A6,-(A7)
	MOVEC	CACR,D6
	MOVE.L	D6,-(A7)
	MOVE.L	#$3110,D6
	MOVEC	D6,CACR
	BSR.S	TREAT_VOICES
	BSR	MIX_SPL
	MOVE.L	(A7)+,D6
	MOVEC	D6,CACR
	MOVEM.L	(A7)+,D0-A6
	
	IFEQ	COLOR
	NOT.W	$FFFF8240.W
	ENDC
	
RETOUR	RTE

TREAT_VOICES
	MOVEQ	#0,D0
	LEA	U(PC),A0
	SUBQ.B	#1,(A0)
	BNE	EFFECT
	MOVE.B	V(PC),(A0)
	MOVE.L	ADDCURPATT(PC),A0
	
	LEA	VOICE0(PC),A1
	BSR	TREAT_ONE_VOICE
	LEA	VOICE1(PC),A1
	BSR	TREAT_ONE_VOICE
	LEA	VOICE2(PC),A1
	BSR	TREAT_ONE_VOICE
	LEA	VOICE3(PC),A1
	BSR	TREAT_ONE_VOICE
	
	LEA	BREAK(PC),A2
	CMP.B	#-1,(A2)
	BNE.S	.LA
	MOVE.B	#0,(A2)
	BRA.S	NEXT_PATT
	
.LA	LEA	ADDCURPATT(PC),A1
	MOVE.L	A0,(A1)
	MOVE.B	PATTDELTIME(PC),D0
	BEQ.S	.DSKC
	LEA	PATTDELTIME2(PC),A0
	MOVE.B	D0,(A0)
	LEA	PATTDELTIME(PC),A0
	MOVE.B	#0,(A0)
.DSKC	LEA	PATTDELTIME2(PC),A0
	TST.B	(A0)
	BEQ.S	.DSKB
	SUBQ.B	#1,(A0)
	BNE.S	.DSKA
.DSKB	LEA	INPATT(PC),A0
	ADDQ.B	#1,(A0)
	CMP.B	#64,(A0)
	BEQ.S	NEXT_PATT
.DSKA	RTS

NEXT_PATT
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.L	ADDCURSEQ(PC),A1
	MOVE.B	POINTSEQ(PC),D0
	ADDQ.B	#1,D0
	CMP.B	CURLEN(PC),D0
	BEQ.S	DO_LOOP_SEQ
OK_PATT	LEA	POINTSEQ(PC),A0
	MOVE.B	D0,(A0)
	MOVE.B	0(A1,D0.W),D0
	MOVE.L	ADDMOD(PC),A0
	MOVE.W	SONEPATT(A0),D1
	MULU	D0,D1
	MOVE.L	SADDPATT(A0),A1
	ADD.L	D1,A1
	LEA	ADDCURPATT(PC),A0
	MOVE.L	A1,(A0)
	LEA	INPATT(PC),A0
	MOVE.B	#0,(A0)
	RTS
DO_LOOP_SEQ
	MOVE.B	CURLOP(PC),D0
	BRA.S	OK_PATT
*************************************************************************
*	A0 = ADD LIGNE PATTERN
*	A1 = ADD DATA VOICE
TREAT_ONE_VOICE
	TST.B	26(A1)				* TEST SI VOIE BUSY
	BNE	C_BUSY

	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	
	CMP.B	#$15,2(A0)
	BEQ.S	DOSETFINETUNE
	CMP.B	#3,2(A0)
	BEQ.S	CHECK_TONE
	CMP.B	#5,2(A0)
	BEQ.S	CHECK_TONE
	BRA.S	SET_P
DOSETFINETUNE
	BSR	SET_FINE_TUNE
	BRA.S	SET_P
CHECK_TONE
	BSR	SET_PORTAMENTO_TONE
	MOVE.B	2(A0),35(A1)
	MOVE.B	3(A0),36(A1)
	ADDQ.W	#4,A0
	RTS

SET_P	MOVE.B	1(A0),D0			* verifie INSTRUMENT
						* si non alors verifie
	BEQ.S	SET_PERIODE			* la note
	MOVE.B	D0,34(A1)
	BSR	INSTR
SET_PERIODE
	MOVE.B	(A0),D1				* NOTE
	BNE.S	GFD
	TST.B	1(A0)				* INSTRU
	BEQ.S	TREAT_EFFECT
	MOVE.W	32(A1),(A1)
	MOVE.B	63(A1),D1
	
GFD	LEA	TABLE_DIGINOTE(PC),A2
	MOVEQ	#0,D0
	MOVE.B	58(A1),D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	(A2,D0.W),A2
	MOVE.B	D1,63(A1)
	SUBQ.W	#1,D1
	ADD.W	D1,D1
	MOVE.W	(A2,D1.L),D0
	MOVE.W	D0,D1
	LSR.W	#8,D0
	AND.W	#$FF,D1
	MOVE.B	D0,(A1)
	MOVE.B	D0,32(A1)
	MOVE.B	D1,1(A1)
	MOVE.B	D1,33(A1)
DFG	
	MOVE.B	2(A0),D0
	CMP.B	#$1D,D0 			; Notedelay
	BEQ.S	TREAT_EFFECT			* mt_CheckMoreEfx

	BTST	#2,51(A1)
	BNE.S	VIBNOC
	CLR.B	52(A1)
VIBNOC	BTST	#6,51(A1)
	BNE.S	TRENOC
	CLR.B	50(A1)
TRENOC	BSR	UPDATE_FUNK
	TST.B	1(A0)
	BNE.S	TREAT_EFFECT
	MOVE.B	34(A1),D0
	BSR.S	INSTR
	
TREAT_EFFECT
	MOVEQ	#0,D0
	MOVE.B	2(A0),D0			* EFFECT NUMBER
	CMP.B	#$20,D0
	BGE.S	ON1
	MOVE.B	D0,35(A1)
	MOVE.B	3(A0),36(A1)
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	TABLE_EFFECT(PC),A2
	MOVE.L	(A2,D0.W),A2
	JSR	(A2)
ON1	ADDQ.W	#4,A0				* NEXT VOICE
NO_EFFECT
	RTS

C_BUSY	CMP.B	#6,27(A1)			* EST-CE UNE VOIE BRUIT ?
	BEQ.S	NO_EFFECT
	BRA.S	ON1
**********************************************************************
INSTR	
	MOVE.L	ADDMOD(PC),A2
	MOVE.L	SADDTABLESPL(A2),A3
	SUBQ.B	#1,D0
	MOVE.W	D0,D1
	LSL.W	#5,D0				* MULU	#32
	LSL.W	#3,D1				* MULU	#8
	ADD.W	D1,D0
	ADD.W	D0,A3
	MOVE.L	22(A3),2(A1)			* ADD DEBUT
	MOVE.L	22(A3),18(A1)			* DANS ADD DEBUT SPL
	MOVE.L	26(A3),38(A1)
	MOVE.B	20(A3),58(A1)			* FINETUNE
	MOVE.B	34(A3),37(A1)			* VOLUME
	MOVE.B	34(A3),22(A1)
	MOVE.B	35(A3),23(A1)			* LOOP OR NOT
	MOVE.W	20(A3),30(A1)			* FRQ DU SPL (6.25,12.5,25,50)
	MOVE.L	36(A3),6(A1)			* ADD LOOP DEBUT
	MOVE.L	36(A3),14(A1)			* DANS WAVE START
	MOVE.L	30(A3),10(A1)			* FIN LOOP
	RTS
**********************************************************************
EFFECT	LEA	VOICE0(PC),A1
	BSR.S	OUT_PAT
	LEA	VOICE1(PC),A1
	BSR.S	OUT_PAT
	LEA	VOICE2(PC),A1
	BSR.S	OUT_PAT
	LEA	VOICE3(PC),A1
	BSR.S	OUT_PAT
*	LEA	VOICE4,(PC)A1
*	BSR.S	OUT_PAT
*	LEA	VOICE5(PC),A1
*	BSR.S	OUT_PAT
*	LEA	VOICE6(PC),A1
*	BSR.S	OUT_PAT
*	LEA	VOICE7(PC),A1
*	BSR.S	OUT_PAT
*	LEA	VOICE8(PC),A1
*	BSR.S	OUT_PAT
*	LEA	VOICE9(PC),A1
*	BSR.S	OUT_PAT
*	LEA	VOICE10(PC),A1
*	BSR.S	OUT_PAT
	RTS

OUT_PAT	MOVEQ	#0,D0
	MOVE.B	35(A1),D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	LEA	TABLE_EFFECT2(PC),A2
	MOVE.L	(A2,D0.W),A2
	JSR	(A2)
	RTS
**********************************************************************
ARPEGGIO
	TST.B	36(A1)
	BEQ	NO_EFFECT
	LEA	AD(PC),A2
	MOVE.B	(A2),D0
	SUBQ.B	#1,D0
	BEQ.S	.ARP1
	MOVE.B	D0,(A2)
	CMP.B	#1,D0
	BEQ.S	.ARP2
	
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	LSR.B	#4,D0
	BRA.S	.ARP3
	
.ARP1	MOVE.B	#3,(A2)
	MOVE.B	36(A1),D0
	AND.W	#$F,D0
	BRA.S	.ARP3
	
.ARP2	MOVE.W	32(A1),(A1)
	RTS
	
.ARP3	LEA	TABLE_DIGINOTE(PC),A2
	ADD.B	63(A1),D0
	ADD.W	D0,D0
	SUBQ.W	#2,D0
	MOVEQ	#0,D1
	MOVE.B	58(A1),D1
	ADD.W	D1,D1
	ADD.W	D1,D1
	MOVE.L	(A2,D1.W),A2
	MOVE.W	(A2,D0.W),(A1)
	RTS
	
**********************************************************************
PORTAMENTO_UP
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	SUB.W	D0,(A1)
	SUB.W	D0,32(A1)
	MOVE.W	(A1),D0
	CMP.W	#$28,D0
	BPL	VOL_OK
	MOVE.W	#$28,(A1)
	MOVE.W	#$28,32(A1)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	RTS
**********************************************************************
PORTAMENTO_DOWN
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	ADD.W	D0,(A1)
	ADD.W	D0,32(A1)
	MOVE.W	(A1),D0
	CMP.W	#$358,D0
	BMI	VOL_OK
	MOVE.W	#$358,(A1)
	MOVE.W	#$358,32(A1)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	RTS
**********************************************************************
SET_PORTAMENTO_TONE
	MOVE.B	(A0),D2
	BEQ	VOL_OK
	MOVEQ	#0,D0
	MOVE.B	58(A1),D0
	LEA	TABLE_DIGINOTE(PC),A2
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	(A2,D0.W),A2
	ADD.W	D2,D2
	
	*MOVE.B	58(A1),D0
	*AND.B	#8,D0
	*BEQ.S	.STPGOSS
	*TST.W	D2
	*BEQ.S	.STPGOSS
	SUBQ.W	#2,A2
.STPGOSS
	MOVE.W	(A2,D2.W),D2
	
	MOVE.W	D2,60(A1)
	MOVE.W	32(A1),D0
	MOVE.B	#0,59(A1)
	CMP.W	D0,D2
	BEQ.S	.CLEARTONEPORTA
	BGE	VOL_OK
	MOVE.B	#1,59(A1)
	RTS
.CLEARTONEPORTA
	MOVE.W	#0,60(A1)
	RTS
**********************************************************************
PORTAMENTO_TONE
	MOVE.B	36(A1),D0
	BEQ.S	TONEPORTNOCHANGE
	MOVE.B	D0,62(A1)
	MOVE.B	#0,36(A1)
TONEPORTNOCHANGE
	TST.W	60(A1)
	BEQ	VOL_OK
	MOVEQ	#0,D0
	MOVE.B	62(A1),D0
	TST.B	59(A1)
	BNE.S	.TONEPORTAUP
.TONEPORTADOWN
	ADD.W	D0,(A1)
	ADD.W	D0,32(A1)
	MOVE.W	60(A1),D0
	CMP.W	(A1),D0
	BGT.S	.TONEPORTASETPER
	MOVE.W	60(A1),(A1)
	MOVE.W	#0,60(A1)
	BRA.S	.TONEPORTASETPER

.TONEPORTAUP
	SUB.W	D0,(A1)
	SUB.W	D0,32(A1)
	MOVE.W	60(A1),D0
	CMP.W	(A1),D0
	BLT.S	.TONEPORTASETPER
	MOVE.W	60(A1),(A1)
	MOVE.W	#0,60(A1)

.TONEPORTASETPER
	MOVE.W	(A1),D2
	MOVE.B	55(A1),D0
	AND.B	#$0F,D0
	BEQ.S	.GLISSKIP
	LEA	TABLE_DIGINOTE(PC),A2
	MOVEQ	#0,D0
	MOVE.B	58(A1),D0
	ADD.W	D0,D0
	ADD.W	D0,D0
	MOVE.L	(A2,D0.W),A2
	MOVEQ	#0,D0
.GLISSLOOP
	CMP.W	(A2,D0.W),D2
	BHS.S	.GLISSFOUND
	ADDQ.W	#2,D0
	CMP.W	#54*2,D0
	BLO.S	.GLISSLOOP
	MOVEQ	#53*2,D0
.GLISSFOUND
	MOVE.W	(A2,D0.W),D2
.GLISSKIP
	MOVE.W	D2,(A1) 			; Set period
	MOVE.W	D2,32(A1)
	RTS
**********************************************************************
VIBRATO	
	MOVE.B	36(A1),D0
	BEQ.S	VIBRATO2
	MOVE.B	46(A1),D2
	AND.B	#$0F,D0
	BEQ.S	.VIBSKIP
	AND.B	#$F0,D2
	OR.B	D0,D2
.VIBSKIP
	MOVE.B	36(A1),D0
	AND.B	#$F0,D0
	BEQ.S	.VIBSKIP2
	AND.B	#$0F,D2
	OR.B	D0,D2
.VIBSKIP2
	MOVE.B	D2,46(A1)
VIBRATO2
	MOVE.B	47(A1),D0
	LEA	SINUS(PC),A5
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	51(A1),D2
	AND.B	#$03,D2
	BEQ.S	.VIB_SINE
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	.VIB_RAMPDOWN
	MOVE.B	#255,D2
	BRA.S	.VIB_SET
.VIB_RAMPDOWN
	TST.B	47(A1)
	BPL.S	.VIB_RAMPDOWN2
	MOVE.B	#255,D2
	SUB.B	D0,D2
	BRA.S	.VIB_SET
.VIB_RAMPDOWN2
	MOVE.B	D0,D2
	BRA.S	.VIB_SET
.VIB_SINE
	MOVE.B	0(A5,D0.W),D2
.VIB_SET
	MOVE.B	46(A1),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#7,D2
	MOVE.W	32(A1),D0			* PERIODE
	TST.B	47(A1)
	BMI.S	.VIBRATONEG
	ADD.W	D2,D0
	BRA.S	.VIBRATO3
.VIBRATONEG
	SUB.W	D2,D0
.VIBRATO3
	MOVE.W	D0,(A1)				* PERIODE
	MOVE.B	46(A1),D0
	LSR.W	#2,D0
	AND.W	#$3C,D0
	ADD.B	D0,47(A1)
	RTS
**********************************************************************
PORT_SLID
	BSR	TONEPORTNOCHANGE
	BRA	VOLUME_SLIDE
	
**********************************************************************
VIB_SLID
	BSR.S	VIBRATO2
	BRA	VOLUME_SLIDE
**********************************************************************
TREMOLO
	MOVEQ	#0,D0
	MOVEQ	#0,D2
	MOVE.B	36(A1),D0
	BEQ.S	.TREMOLO2
	MOVE.B	49(A1),D2
	AND.B	#$0F,D0
	BEQ.S	.TRESKIP
	AND.B	#$F0,D2
	OR.B	D0,D2
.TRESKIP
	MOVE.B	36(A1),D0
	AND.B	#$F0,D0
	BEQ.S	.TRESKIP2
	AND.B	#$0F,D2
	OR.B	D0,D2
.TRESKIP2
	MOVE.B	D2,49(A1)
.TREMOLO2
	MOVE.B	50(A1),D0
	LEA	SINUS(PC),A5
	LSR.W	#2,D0
	AND.W	#$001F,D0
	MOVEQ	#0,D2
	MOVE.B	51(A1),D2
	LSR.B	#4,D2
	AND.B	#$03,D2
	BEQ.S	.TRE_SINE
	LSL.B	#3,D0
	CMP.B	#1,D2
	BEQ.S	.TRE_RAMPDOWN
	MOVE.B	#255,D2
	BRA.S	.TRE_SET
.TRE_RAMPDOWN
	TST.B	52(A1)
	BPL.S	.TRE_RAMPDOWN2
	MOVE.B	#255,D2
	SUB.B	D0,D2
	BRA.S	.TRE_SET
.TRE_RAMPDOWN2
	MOVE.B	D0,D2
	BRA.S	.TRE_SET
.TRE_SINE
	MOVE.B	0(A5,D0.W),D2
.TRE_SET
	MOVE.B	49(A1),D0
	AND.W	#15,D0
	MULU	D0,D2
	LSR.W	#6,D2
	MOVEQ	#0,D0
	MOVE.B	37(A1),D0		* VOLUME
	TST.B	50(A1)
	BMI.S	.TREMOLONEG
	ADD.W	D2,D0
	BRA.S	.TREMOLO3
.TREMOLONEG
	SUB.W	D2,D0
.TREMOLO3
	BPL.S	.TREMOLOSKIP
	CLR.W	D0
.TREMOLOSKIP
	CMP.W	#$40,D0
	BLS.S	.TREMOLOK
	MOVE.W	#$40,D0
.TREMOLOK
	MOVE.W	D0,22(A1)
	MOVE.B	49(A1),D0
	LSR.W	#2,D0
	AND.W	#$003C,D0
	ADD.B	D0,50(A1)
	RTS
**********************************************************************
SAMPLEOFFSET
	MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	BEQ.S	.NONEW
	MOVE.B	D0,48(A1)
.NONEW	MOVE.B	48(A1),D0
	LSL.W	#8,D0
	ADD.L	D0,2(A1)
	MOVE.L	2(A1),D0
	MOVE.L	10(A1),D1
	CMP.L	D0,D1
	BLT.S	.NOOK
	RTS
.NOOK	MOVE.L	D1,2(A1)
	SUB.L	#10,2(A1)
	RTS
**********************************************************************
VOLUME_SLIDE
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	LSR.B	#4,D0
	TST.B	D0
	BEQ.S	VOL_DOWN
VUP	ADD.B	D0,37(A1)
	CMP.B	#$40,37(A1)
	BMI.S	VOL_OK
	MOVE.B	#$40,37(A1)
	RTS
VOL_DOWN
	MOVE.B	36(A1),D0
	AND.B	#$F,D0
VDO	SUB.B	D0,37(A1)
	BPL.S	VOL_OK
	MOVE.B	#0,37(A1)
	RTS
	
**********************************************************************
POS_JUMP
	LEA	BREAK(PC),A2
	MOVE.B	#-1,(A2)
	MOVE.B	36(A1),D0
	SUBQ.B	#1,D0
	LEA	POINTSEQ(PC),A2
	MOVE.B	D0,(A2)
JPP	LEA	BREAKPOS(PC),A2
	MOVE.B	#0,(A2)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	RTS
	
**********************************************************************
SET_VOLUME
	MOVE.B	36(A1),37(A1)
	MOVE.B	36(A1),22(A1)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	CMP.B	#$40,37(A1)
	BMI.S	VOL_OK
	MOVE.B	#$40,37(A1)
	MOVE.B	#$40,22(A1)
VOL_OK	RTS
	
**********************************************************************
PATT_BREAK
	LEA	BREAK(PC),A2
	MOVE.B	#-1,(A2)
	MOVE.B	3(A0),D0
	CMP.B	#63,D0
	BHI.S	JPP
	LEA	BREAKPOS(PC),A2
	MOVE.B	D0,(A2)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	RTS
	
**********************************************************************
SET_SPEED
	MOVE.B	3(A0),D0
	AND.W	#$1F,D0
	LEA	U(PC),A2
	MOVE.B	D0,(A2)
	LEA	V(PC),A2
	MOVE.B	D0,(A2)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	TST.B	(A2)
	BNE.S	VOL_OK
	MOVE.B	#1,(A2)
	RTS
**********************************************************************
FINE_PORT_UP
	LEA	U(PC),A2
	TST.B	(A2)
	BNE.S	VOL_OK
	LEA	LOWMASK(PC),A2
	MOVE.B	#$0F,(A2)
PORTAUP MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	AND.B	(A2),D0
	MOVE.B	#$FF,(A2)
	SUB.W	D0,(A1)
	MOVE.W	(A1),D0
	CMP.W	#113,D0
	BPL.S	VOL_OK
	AND.W	#$F000,(A1)
	OR.W	#113,(A1)
	RTS
**********************************************************************
FINE_PORT_DOWN
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	LEA	LOWMASK(PC),A2
	MOVE.B	#$0F,(A2)
PORTADOWN
	MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	AND.B	(A2),D0
	MOVE.B	#$FF,(A2)
	ADD.W	D0,(A1)
	MOVE.W	(A1),D0
	AND.W	#$0FFF,D0
	CMP.W	#856,D0
	BMI	VOL_OK
	AND.W	#$F000,(A1)
	OR.W	#856,(A1)
	RTS
**********************************************************************
SET_GLISSANDO_CONTROL
	MOVE.B	3(A0),D0
	AND.B	#$F0,55(A1)
	OR.B	D0,55(A1)
	RTS
**********************************************************************
SET_VIBRATO_CONTROL
	MOVE.B	3(A0),D0
	AND.B	#$F0,51(A1)
	OR.B	D0,51(A1)
	RTS
**********************************************************************
SET_FINE_TUNE
	MOVE.B	3(A0),58(A1)
	RTS
**********************************************************************
JUMP_LOOP
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	MOVE.B	3(A0),D0
	AND.B	#$0F,D0
	BEQ.S	.SETLOOP
 	TST.B	64(A0)
	BEQ.S	.JUMPCNT
	SUBQ.B	#1,64(A0)
	BEQ	VOL_OK
.JMPLOOP
	LEA	BREAKPOS(PC),A2	
	MOVE.B	65(A0),(A2)
	LEA	BREAK(PC),A2
	MOVE.B	#-1,(A2)
	RTS
.JUMPCNT	
	MOVE.B	D0,64(A0)
	BRA.S	.JMPLOOP
.SETLOOP	
	MOVE.B	INPATT(PC),65(A0)
	RTS
**********************************************************************
SET_TREMOLO_CONTROL
	MOVE.B	3(A0),D0
	AND.B	#$0F,D0
	LSL.B	#4,D0
	AND.B	#$0F,51(A1)
	OR.B	D0,51(A1)
	RTS
**********************************************************************
RETRIG_NOTE
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	BEQ	VOL_OK
	MOVEQ	#0,D1
	MOVE.B	U(PC),D1
	BNE.S	.RTNSKP
	MOVE.W	32(A1),D1				* ???
	BNE	VOL_OK
	MOVEQ	#0,D1
	MOVE.B	U(PC),D1
.RTNSKP	DIVU	D0,D1
	SWAP	D1
	TST.W	D1
	BNE	VOL_OK
	MOVE.L	18(A1),2(A1)			* ADD DEBUT SPL
	RTS
**********************************************************************
VOLUME_FINE_UP
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	AND.B	#$F,D0
	BRA	VUP
**********************************************************************
VOLUME_FINE_DOWN
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	AND.B	#$0F,D0
	BRA	VDO
**********************************************************************
NOTE_CUTE
	MOVEQ	#0,D0
	MOVE.B	36(A1),D0
	CMP.B	U(PC),D0
	BNE	VOL_OK
	MOVE.B	#0,37(A1)
	RTS
**********************************************************************
NOTE_DELAY
	MOVEQ	#0,D0
	MOVE.L	D0,2(A1)
	MOVE.B	36(A1),D0
	CMP.B	U(PC),D0
	BNE	VOL_OK
	MOVE.L	18(A1),2(A1)
	MOVE.B	#0,35(A1)
	MOVE.B	#0,36(A1)
	RTS
**********************************************************************
PATTERN_DELAY
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	MOVEQ	#0,D0
	MOVE.B	3(A0),D0
	LEA	PATTDELTIME2(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	ADDQ.B	#1,D0
	LEA	PATTDELTIME(PC),A2
	MOVE.B	D0,(A2)
	RTS

**********************************************************************
FUNK_IT
	LEA	U(PC),A2
	TST.B	(A2)
	BNE	VOL_OK
	MOVE.B	3(A0),D0
	AND.B	#$0F,D0
	LSL.B	#4,D0
	AND.B	#$0F,55(A1)
	OR.B	D0,55(A1)
	TST.B	D0
	BEQ	VOL_OK
UPDATE_FUNK
	MOVEQ	#0,D0
	MOVE.B	55(A1),D0
	LSR.B	#4,D0
	BEQ.S	.FUNKEND
	LEA	FUNK_TABLE(PC),A2
	MOVE.B	(A2,D0.W),D0
	ADD.B	D0,56(A1)
	BTST	#7,56(A1)
	BEQ.S	.FUNKEND
	CLR.B	56(A1)
	MOVE.L	10(A1),D0			* FIN DU SAMPLE
	MOVE.L	14(A1),A2
	ADDQ.L	#1,A2
	CMP.L	D0,A2
	BLO.S	.FUNKOK
	MOVE.L	10(A1),A2
.FUNKOK	MOVE.L	A2,14(A1)
	MOVEQ	#-1,D0
	SUB.B	(A2),D0
	MOVE.B	D0,(A2)
.FUNKEND	RTS
**************  POUR ARRETER LE PLAYER  *********************************
END	MOVE.W	SR,-(A7)
	MOVE.W	#$2700,SR
	MOVE.L	#$0A00A00,$FFFF8800.W
	MOVE.L	#$0900900,$FFFF8800.W
	MOVE.L	#$0800800,$FFFF8800.W
	MOVE.L	#0,$FFFF8900.W
	BSR	RESTORE
	MOVE.W	(A7)+,SR
	RTS
*************************************************************************
*	D0 = EQUIVALENCE D'UNE LIGNE PATTERN
*	D1 = VOIE UTILISE
BRUIT
	MOVEM.L	D0-A6,-(A7)
	LEA	VOICE0(PC),A1
	MULU	#66,D1
	ADD.W	D1,A1
	LEA	LIGNE(PC),A0
	MOVE.L	D0,(A0)
	MOVE.B	#0,26(A1)
	BSR	TREAT_ONE_VOICE
	MOVE.B	#1,26(A1)			* VOICE IS BUSY
	MOVEM.L (A7)+,D0-A6
	RTS
**************  MIXAGE DES VOIX  ****************************************
MIX_SPL
	LEA	VOICE0(PC),A6
	BSR.S	CHOIX
	LEA	VOICE1(PC),A6
	BSR.S	CHOIX
	LEA	VOICE2(PC),A6
	BSR.S	CHOIX
	LEA	VOICE3(PC),A6
	BSR.S	CHOIX
*	LEA	VOICE4(PC),A6
*	BSR	CHOIX
*	LEA	VOICE5(PC),A6
*	BSR	CHOIX
*	LEA	VOICE6(PC),A6
*	BSR	CHOIX
*	LEA	VOICE7(PC),A6
*	BSR	CHOIX
*	LEA	VOICE8(PC),A6
*	BSR	CHOIX
*	LEA	VOICE9(PC),A6
*	BSR	CHOIX
*	LEA	VOICE10(PC),A6
*	BSR	CHOIX
	LEA	VOID(PC),A6
	MOVE.B	#0,(A6)
FINVBL	RTS
***************  GESTION DE LA FREQUENCE  ********************************
CHOIX	LEA	TABLE_CHOIX(PC),A0
	MOVE.W	24(A6),D0
	MOVE.L	(A0,D0.W*4),A0
	JMP	(A0)
*--------------------------------------------------------------------------
CHOIXFRQ
	BSR	CHOIFRQ
	BSR	JOUE_SAMPLE
	BSR	TEST_FIN_SAMPLE
	RTS
*--------------------------------------------------------------------------
JOUE_SAMPLE	
	MOVE.L	DEB_BUF(PC),A5
	MOVEQ	#0,D0
	MOVE.B	VOID(PC),D0
	ADD.B	D0,D0
	ADD.L	D0,A5
	
.FIST	MOVE.L	2(A6),A0		* ADRESSE DEBUT
	TST.L	2(A6)
	BNE.S	.PASZERO
	LEA	RIEN(PC),A0
.PASZERO
	MOVEM.L	RIEN(PC),D0/D2-D4/D7	
	LEA	FRQ(PC),A4
	MOVE.W	(A6),D7			* NOTE
	BEQ.S	.RFV
	MOVE.W	(A4,D7.W*4),D2
	MOVE.W	2(A4,D7.W*4),D0
.RFV	MOVE.B	37(A6),D4
	BEQ.S	.V_NUL
	SUBQ.W	#1,D4
	MULU	#$200,D4
.V_NUL	LEA	VOLUME(PC),A4
	ADD.L	D4,A4
	
	MOVE.L	#$3111,D6
	MOVEC	D6,CACR
ROUTINE	JSR	VFRQ2W
	MOVEC	D6,CACR
	MOVE.L	#$3110,D6
	RTS
*--------------------------------------------------------------------------
TEST_FIN_SAMPLE
	TST.L	2(A6)
	BEQ.S	.PARES
	ADD.W	D3,A0
	MOVE.L	A0,2(A6)
	MOVE.L	A0,D0
	MOVE.L	10(A6),D1
	CMP.L	D0,D1
	BGE.S	.PARES
	BRA.S	.CALCRESTE
	RTS

.CALCRESTE
	CMP.B	#1,23(A6)
	BNE.S	.UNLOOP
	MOVE.W	#0,(A6)
	MOVE.L	#0,2(A6)
	TST.W	26(A6)				* ETAIT-CE BUSY
	BEQ.S	.PARES
	CLR.B	26(A6)
.PARES	RTS

.UNLOOP	MOVE.L	2(A6),D0
	MOVE.L	10(A6),D1
	SUB.L	D1,D0
	MOVE.L	6(A6),2(A6)
	ADD.L	D0,2(A6)
.YET	MOVE.L	2(A6),D1
	MOVE.L	10(A6),D2
	CMP.L	D2,D1
	BGE.S	.RECAL
	RTS
.RECAL	
	SUB.L	6(A6),D1
	SUB.L	6(A6),D2
	SUB.L	D2,D1
	MOVE.L	6(A6),2(A6)
	ADD.L	D1,2(A6)
	BRA.S	.YET
*--------------------------------------------------------------------------
CHOIFRQ
	LEA	VOID(PC),A1
	LEA	DIGVOICES(PC),A0
	CMP.B	#1,(A0)			* SI 1 VOIE DIGITAL
	BNE.S	.PAS1
	LEA	PIL1(PC),A0
	BRA.S	CALCVOICE
.PAS1	TST.B	(A1)
	BNE.S	.CH2
	LEA	PIL2(PC),A0
	BRA.S	CALCVOICE
.CH2	CMP.B	#1,(A1)
	BNE.S	.CH3
	LEA	PIL2(PC),A0
	BRA.S	CALCVOICE
.CH3	LEA	PIL3(PC),A0
CALCVOICE
	LEA	VOID(PC),A5
	ADDQ.B	#1,(A5)
	MOVEQ	#0,D0
	MOVE.B	25(A6),D0
	SUBQ.W	#4,D0
	LEA	ROUTINE+2(PC),A5
	MOVE.L	(A0,D0.W*4),(A5)
	RTS
*****************  GESTION DES DRUMS  ************************************
CHOIXDRUM
	RTS
*************  INITIALISATION ET RELOGEMENT  *****************************
*************          DU PLAYER             *****************************
INIT	MOVEM.L	D0-A6,-(A7)
	MOVEQ	#0,D1
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	JSR	CMOD(PC)
	
	MOVE.W	RELOGE(PC),D1
	CMP.W	#1,D1
	BEQ	DEJA
	
	LEA	DEB_BUF(PC),A2
	LEA	MUSDEB(PC),A3
	MOVE.L	A3,(A2)
	ADD.W	#VAL*4,A3
	MOVE.L	A3,4(A2)

	BSR	SYNC_DAC
	
	MOVE.W	#$80,-(A7)		* LOCK SOUND
	TRAP	#14
	ADDQ.W	#2,A7
	
	*MOVE.W	#6,-(A7)
	*MOVE.W	#6,-(A7)
	*MOVE.W	#$82,-(A7)		* SOUND COMMAND
	*TRAP	#14
	*ADDQ.W	#6,A7
	
	MOVE.W	#1,-(A7)		* 16 BITS STEREO
	MOVE.W	#$84,-(A7)		* SET MODE
	TRAP	#14
	ADDQ.W	#4,A7

	MOVE.W	#0,-(A7)		* 0 PLAY TRACK
	MOVE.W	#0,-(A7)		* 0 RECORD TRACK
	MOVE.W	#$85,-(A7)		* SET TRACKS
	TRAP	#14
	ADDQ.W	#6,A7
	
	MOVE.W	#0,-(A7)		* # OF TRACK OUTPUT TO INTERNAL SPEAKER
	MOVE.W	#$86,-(A7)		* SETMONTRACK
	TRAP	#14
	ADDQ.W	#4,A7	
	
	MOVE.W	#1,-(A7)		* 
	MOVE.W	#0,-(A7)		* 
	MOVE.W	#$87,-(A7)		* SET INTERRUPT
	TRAP	#14
	ADDQ.W	#6,A7	
	
	MOVE.W	#3,-(A7)		* PLAY ENABLE , PLAY REPEAT
	MOVE.W	#$88,-(A7)		* BUFFOPER
	TRAP	#14
	ADDQ.W	#4,A7	
	
	MOVE.W	#1,-(A7)		* PROTOCOL = DISABLE HANDSHAKING
	IFNE	FREQU=12292
	MOVE.W	#7,-(A7)		* PRESCALE = 12.2 KHZ
	ENDC
	IFNE	FREQU=16490
	MOVE.W	#5,-(A7)		* PRESCALE = 16.4 KHZ
	ENDC
	IFNE	FREQU=20770
	MOVE.W	#4,-(A7)		* PRESCALE = 20.7 KHZ
	ENDC
	IFNE	FREQU=24585
	MOVE.W	#3,-(A7)		* PRESCALE = 24.5 KHZ
	ENDC
	IFNE	FREQU=33880
	MOVE.W	#2,-(A7)		* PRESCALE = 33.8 KHZ
	ENDC
	IFNE	FREQU=49170
	MOVE.W	#1,-(A7)		* PRESCALE = 49.1 KHZ
	ENDC
	MOVE.W	#0,-(A7)		* SRCLK    = INTERNAL 25.175 MHZ CLOCK
	MOVE.W	#8,-(A7)		* DEST     = DAC (HEADPHONE)
	MOVE.W	#0,-(A7)		* SRC      = DMA PLAY
	MOVE.W	#$8B,-(A7)		* DEVCONNECT
	TRAP	#14
	ADD.W	#12,A7	
	
	MOVE.L	ADDMOD(PC),A1
	MOVE.L	A1,A0			* RELOGE
	MOVE.L	A0,D1
	ADD.L	D1,34(A1)
	ADD.L	D1,38(A1)
	ADD.L	D1,46(A1)
	ADD.L	D1,50(A1)
	ADD.L	D1,54(A1)
	ADD.L	D1,66(A1)
	
	MOVE.L	SADDTABLESPL(A1),A2
	MOVE.W	SLENTABLESPL(A1),D1
	TST.W	D1
	BEQ.S	RYAM
	MOVE.L	SADDSPL(A1),D2
RCO1	TST.L	26(A2)
	BEQ.S	RCO2
	ADD.L	D2,22(A2)
	ADD.L	D2,30(A2)
	ADD.L	D2,36(A2)
RCO2	ADD.W	#40,A2
	ADD.W	#40,D3
	CMP.W	D1,D3
	BLT.S	RCO1
	
RYAM	MOVE.L	SADDTABLEYAM(A1),A2
	MOVE.W	SLENTABLEYAM(A1),D1
	TST.W	D1
	BEQ.S	NYAM
	MOVEQ	#0,D3
RCO3	TST.L	26(A2)
	BEQ.S	RCO4
	ADD.L	D2,22(A2)
	ADD.L	D2,30(A2)
	ADD.L	D2,36(A2)
RCO4	ADD.W	#40,A2
	ADD.W	#40,D3
	CMP.W	D1,D3
	BLT.S	RCO3
NYAM	LEA	RELOGE(PC),A2
	MOVE.W	#1,(A2)
	LEA	DIGVOICES(PC),A2
	MOVE.B	17(A1),(A2)
	LEA	VOICE0(PC),A2
	MOVE.B	6(A1),25(A2)
	LEA	VOICE1(PC),A2
	MOVE.B	7(A1),25(A2)
	LEA	VOICE2(PC),A2
	MOVE.B	8(A1),25(A2)
	LEA	VOICE3(PC),A2
	MOVE.B	9(A1),25(A2)
	LEA	VOICE4(PC),A2
	MOVE.B	10(A1),25(A2)
	LEA	VOICE5(PC),A2
	MOVE.B	11(A1),25(A2)
	LEA	VOICE6(PC),A2
	MOVE.B	12(A1),25(A2)
	LEA	VOICE7(PC),A2
	MOVE.B	13(A1),25(A2)
	LEA	VOICE8(PC),A2
	MOVE.B	14(A1),25(A2)
	LEA	VOICE9(PC),A2
	MOVE.B	15(A1),25(A2)
	LEA	VOICE10(PC),A2
	MOVE.B	16(A1),25(A2)
	
	LEA	PIL1(PC),A2
	LEA	FRQ1W(PC),A3
	MOVE.L	A3,(A2)
	LEA	VFRQ1W(PC),A3
	MOVE.L	A3,4(A2)
	
	LEA	PIL2(PC),A2
	LEA	FRQ2W(PC),A3
	MOVE.L	A3,(A2)
	LEA	VFRQ2W(PC),A3
	MOVE.L	A3,4(A2)
	
	LEA	PIL3(PC),A2
	LEA	FRQ3W(PC),A3
	MOVE.L	A3,(A2)
	LEA	VFRQ3W(PC),A3
	MOVE.L	A3,4(A2)

	LEA	DPIL1(PC),A2
	LEA	NORM_VOL1(PC),A3
	MOVE.L	A3,4(A2)
	LEA	DPIL2(PC),A2
	LEA	NORM2(PC),A3
	MOVE.L	A3,(A2)
	LEA	NORM_VOL2(PC),A3
	MOVE.L	A3,4(A2)
	LEA	DPIL3(PC),A2
	LEA	ADD_(PC),A3
	MOVE.L	A3,(A2)
	LEA	ADD_VOL(PC),A3
	MOVE.L	A3,4(A2)
	
	LEA	NORM_VOL1(PC),A2
	LEA	D625R25(PC),A3
	MOVE.L	A3,(A2)
	LEA	D625R125(PC),A3
	MOVE.L	A3,8(A2)
	LEA	D625R625(PC),A3
	MOVE.L	A3,16(A2)
	LEA	D125R625(PC),A3
	MOVE.L	A3,24(A2)

	LEA	NORM_VOL2(PC),A2
	LEA	D625R25_VOL(PC),A3
	MOVE.L	A3,(A2)
	LEA	D625R125_VOL(PC),A3
	MOVE.L	A3,8(A2)
	LEA	D625R625_VOL(PC),A3
	MOVE.L	A3,16(A2)
	LEA	D125R625_VOL(PC),A3
	MOVE.L	A3,24(A2)
	
	LEA	ADD_(PC),A2
	LEA	D625R25_ADD(PC),A3
	MOVE.L	A3,(A2)
	LEA	D625R125_ADD(PC),A3
	MOVE.L	A3,8(A2)
	LEA	D625R625_ADD(PC),A3
	MOVE.L	A3,16(A2)
	LEA	D125R625_ADD(PC),A3
	MOVE.L	A3,24(A2)
	
	LEA	ADD_VOL(PC),A2
	LEA	D625R25_VOL_ADD(PC),A3
	MOVE.L	A3,(A2)
	LEA	D625R125_VOL_ADD(PC),A3
	MOVE.L	A3,8(A2)
	LEA	D625R625_VOL_ADD(PC),A3
	MOVE.L	A3,16(A2)
	LEA	D125R625_VOL_ADD(PC),A3
	MOVE.L	A3,24(A2)
	
	LEA	TABLE_CHOIX(PC),A2
	LEA	FINVBL(PC),A3
	MOVE.L	A3,(A2)
	MOVE.L	A3,4(A2)
	LEA	CHOIXDRUM(PC),A3
	MOVE.L	A3,8(A2)
	MOVE.L	A3,12(A2)
	LEA	CHOIXFRQ(PC),A3
	MOVE.L	A3,16(A2)
	MOVE.L	A3,20(A2)
	MOVE.L	A3,24(A2)
	MOVE.L	A3,28(A2)
	
	LEA	TABLE_EFFECT(PC),A2
	LEA	NO_EFFECT(PC),A3
	MOVE.L	A3,(A2)				*0
	MOVE.L	A3,4(A2)			*1
	MOVE.L	A3,8(A2)			*2
	LEA	SET_PORTAMENTO_TONE(PC),A4
	MOVE.L	A4,12(A2)			*3
	MOVE.L	A3,16(A2)			*4
	MOVE.L	A3,20(A2)			*5
	MOVE.L	A3,24(A2)			*6
	MOVE.L	A3,28(A2)			*7
	MOVE.L	A3,32(A2)			*8
	LEA	SAMPLEOFFSET(PC),A4
	MOVE.L	A4,36(A2)			*9
	MOVE.L	A3,40(A2)			*A
	LEA	POS_JUMP(PC),A4
	MOVE.L	A4,44(A2)			*B
	LEA	SET_VOLUME(PC),A4
	MOVE.L	A4,48(A2)			*C
	LEA	PATT_BREAK(PC),A4
	MOVE.L	A4,52(A2)			*D
	MOVE.L	A3,56(A2)			*E
	LEA	SET_SPEED(PC),A4
	MOVE.L	A4,60(A2)			*F
	MOVE.L	A3,64(A2)			*10
	LEA	FINE_PORT_UP(PC),A4
	MOVE.L	A4,68(A2)			*11
	LEA	FINE_PORT_DOWN(PC),A4
	MOVE.L	A4,72(A2)			*12
	LEA	SET_GLISSANDO_CONTROL(PC),A4
	MOVE.L	A4,76(A2)			*13
	LEA	SET_VIBRATO_CONTROL(PC),A4
	MOVE.L	A4,80(A2)			*14
	LEA	SET_FINE_TUNE(PC),A4
	MOVE.L	A4,84(A2)			*15
	LEA	JUMP_LOOP(PC),A4
	MOVE.L	A4,88(A2)			*16
	LEA	SET_TREMOLO_CONTROL(PC),A4
	MOVE.L	A4,92(A2)			*17
	MOVE.L	A3,96(A2)			*18
	LEA	RETRIG_NOTE(PC),A4
	MOVE.L	A4,100(A2)			*19
	LEA	VOLUME_FINE_UP(PC),A4
	MOVE.L	A4,104(A2)			*1A
	LEA	VOLUME_FINE_DOWN(PC),A4
	MOVE.L	A4,108(A2)			*1B
	LEA	NOTE_CUTE(PC),A4
	MOVE.L	A4,112(A2)			*1C
	LEA	NOTE_DELAY(PC),A4
	MOVE.L	A4,116(A2)			*1D
	LEA	PATTERN_DELAY(PC),A4
	MOVE.L	A4,120(A2)			*1E
	LEA	FUNK_IT(PC),A4
	MOVE.L	A4,124(A2)			*1F
	
	LEA	TABLE_EFFECT2(PC),A2
	LEA	ARPEGGIO(PC),A4
	MOVE.L	A4,(A2)				*0
	LEA	PORTAMENTO_UP(PC),A4
	MOVE.L	A4,4(A2)			*1
	LEA	PORTAMENTO_DOWN(PC),A4
	MOVE.L	A4,8(A2)			*2
	LEA	PORTAMENTO_TONE(PC),A4
	MOVE.L	A4,12(A2)			*3
	LEA	VIBRATO(PC),A4
	MOVE.L	A4,16(A2)			*4
	LEA	PORT_SLID(PC),A4
	MOVE.L	A4,20(A2)			*5
	LEA	VIB_SLID(PC),A4
	MOVE.L	A4,24(A2)			*6
	LEA	TREMOLO(PC),A4
	MOVE.L	A4,28(A2)			*7
	MOVE.L	A3,32(A2)			*8
	MOVE.L	A3,36(A2)			*9
	LEA	VOLUME_SLIDE(PC),A4
	MOVE.L	A4,40(A2)			*A
	MOVE.L	A3,44(A2)			*B
	MOVE.L	A3,48(A2)			*C
	MOVE.L	A3,52(A2)			*D
	MOVE.L	A3,56(A2)			*E
	MOVE.L	A3,60(A2)			*F
	MOVE.L	A3,64(A2)			*10
	MOVE.L	A3,68(A2)			*11
	MOVE.L	A3,72(A2)			*12
	MOVE.L	A3,76(A2)			*13
	MOVE.L	A3,80(A2)			*14
	MOVE.L	A3,84(A2)			*15
	MOVE.L	A3,88(A2)			*16
	MOVE.L	A3,92(A2)			*17
	MOVE.L	A3,96(A2)			*18
	LEA	RETRIG_NOTE(PC),A4
	MOVE.L	A4,100(A2)			*19
	MOVE.L	A3,104(A2)			*1A
	MOVE.L	A3,108(A2)			*1B
	LEA	NOTE_CUTE(PC),A4
	MOVE.L	A4,112(A2)			*1C
	LEA	NOTE_DELAY(PC),A4
	MOVE.L	A4,116(A2)			*1D
	MOVE.L	A3,120(A2)			*1E
	MOVE.L	A3,124(A2)			*1F
	

	
	LEA	TABLE_DIGINOTE(PC),A2
	LEA	DIGINOTE1(PC),A3
	MOVEQ	#15,D1
.ULP	MOVE.L	A3,(A2)+
	ADD.W	#54*2,A3
	DBF	D1,.ULP

TEST_DAC

	MOVE.W	SR,-(A7)
	MOVE.W	#$2700,SR
	BSR	STORE

	MOVE.W	#$7FF,$FFFF8924.W
	MOVE.W	#$488,$FFFF8922.W
	BCLR	#3,$FFFFFA17.W
	BSET	#5,$FFFFFA07.W
	BSET	#5,$FFFFFA13.W
	MOVE.B	#0,$FFFFFA19.W
	MOVE.B	#1,$FFFFFA1F.W
	MOVE.B	#8,$FFFFFA19.W
		
	MOVE.W	#$2300,SR
	MOVE.W	(A7)+,SR	

DEJA	CMP.B	SNBZIC(A1),D0		* PREPARE LA MUSIQUE
	BGE.S	FIN_INIT
	
	LEA	MUSDEB(PC),A2
	MOVE.L	#VAL,D1
	MOVEQ	#0,D2
CLEAR	MOVE.L	D2,(A2)+
	DBF	D1,CLEAR
	
	MOVE.L	D0,D1
	LEA	CURMUS(PC),A0
	MOVE.B	D0,(A0)
	LSL.L	#8,D0			*MULU	#256
	MOVE.L	SADDSEQ(A1),A2
	ADD.L	D0,A2
	LEA	ADDCURSEQ(PC),A0
	MOVE.L	A2,(A0)
	LEA	POINTSEQ(PC),A0
	MOVE.B	#0,(A0)
	
	LSL.W	#1,D1			*MULU	#2
	MOVE.L	SADDZIC(A1),A2
	ADD.W	D1,A2
	LEA	CURLEN(PC),A0
	MOVE.B	(A2),(A0)
	ADDQ.B	#1,(A0)
	LEA	CURLOP(PC),A0
	MOVE.B	1(A2),(A0)
	
	MOVEQ	#0,D0
	MOVEQ	#0,D1
	MOVE.L	ADDCURSEQ(PC),A0
	MOVE.B	(A0),D0
	MOVE.W	SONEPATT(A1),D1
	MULU	D1,D0
	MOVE.L	SADDPATT(A1),A0
	ADD.L	D0,A0
	LEA	ADDCURPATT(PC),A2
	MOVE.L	A0,(A2)
	LEA	INPATT(PC),A0
	MOVE.B	#0,(A0)
FIN_INIT
	MOVEM.L	(A7)+,D0-A6
	RTS
***********************************************************************
NULL	RTE
***********************************************************************
STORE	LEA	SAVE_REGISTER(PC),A0
	MOVE.L	$134.W,(A0)+
	MOVE.L	$110.W,(A0)+
	MOVE.L	$FFFFFA06.W,(A0)+
	MOVE.L	$FFFFFA12.W,(A0)+
	MOVE.L	$FFFFFA16.W,(A0)+
	MOVE.B	$FFFFFA1F.W,(A0)+
	MOVE.B	$FFFFFA25.W,(A0)+
	RTS
RESTORE LEA	SAVE_REGISTER(PC),A0
	MOVE.L	(A0)+,$134.W
	MOVE.L	(A0)+,$110.W
	MOVE.L	(A0)+,$FFFFFA06.W
	MOVE.L	(A0)+,$FFFFFA12.W
	MOVE.L	(A0)+,$FFFFFA16.W
	MOVE.B	(A0)+,$FFFFFA1F.W
	MOVE.B	(A0)+,$FFFFFA25.W
	RTS
*************************************************************************
***********  VARIABLES ET TABLES  ***************************************
*************************************************************************
INPATT		DC.B	0
DIGVOICES	DC.B	0
BREAK		DC.B	0
LOWMASK		DC.B	0
PATTDELTIME	DC.B	0
PATTDELTIME2	DC.B	0
AD		DC.B	3
		EVEN
		
BREAKPOS	DC.W	0

ADDMOD		DC.L	0
RELOGE		DC.W	0		* SI = 1 ALORS DEJA RELOGE
ADDCURSEQ	DC.L	0		* ADDRESSE DE LA SEQ COURANTE
ADDCURPATT	DC.L	0		*		 PATT
POINTSEQ	DC.B	0		* POINTEUR DANS LA SEQ COURANTE
CURMUS		DC.B	0		* MUSIQUE COURANTE
CURLEN		DC.B	0		* LONGUEUR DE LA ZIC COURANTE
CURLOP		DC.B	0		* BOUCLE
U		DC.B	6
V		DC.B	6

VOID		DC.B	0		* NB DE VOIES DIGITALES RENCONTREES
VOIY		DC.B	0		* NB DE VOIES YAMAHA    RENCONTREES
PERIODE		DC.L	0
LIGNE		DC.L	0

VOICE0		DS.B	66
VOICE1		DS.B	66
VOICE2		DS.B	66
VOICE3		DS.B	66
VOICE4		DS.B	66
VOICE5		DS.B	66
VOICE6		DS.B	66
VOICE7		DS.B	66
VOICE8		DS.B	66
VOICE9		DS.B	66
VOICE10		DS.B	66

SAVE_REGISTER	DCB.L	6
DEB_BUF		DC.L	0
		DC.L	0

MUSDEB
		DS.B	VAL*4*2
MUSFIN		ds.b	3000

PIL1		DC.L	FRQ1W,VFRQ1W
PIL2		DC.L	FRQ2W,VFRQ2W
PIL3		DC.L	FRQ3W,VFRQ3W

DPIL1		DC.L	0,NORM_VOL1		* 0 CAR DRUM DU DAC
DPIL2		DC.L	NORM2,NORM_VOL2
DPIL3		DC.L	ADD_,ADD_VOL

NORM_VOL1					* 0 CAR PAS FAIT
NORM2		DC.L	D625R25,6		* DRUM A  6.25
		DC.L	D625R125,6		* DRUM A 12.5
		DC.L	D625R625,6		* DRUM A 25 
		DC.L	D125R625,6		* DRUM A 50
NORM_VOL2	DC.L	D625R25_VOL,10
		DC.L	D625R125_VOL,10
		DC.L	D625R625_VOL,10
		DC.L	D125R625_VOL,10
ADD_		DC.L	D625R25_ADD,8
		DC.L	D625R125_ADD,8
		DC.L	D625R625_ADD,8
		DC.L	D125R625_ADD,8
ADD_VOL		DC.L	D625R25_VOL_ADD,12
		DC.L	D625R125_VOL_ADD,12
		DC.L	D625R625_VOL_ADD,12
		DC.L	D125R625_VOL_ADD,12

TABLE_CHOIX	DC.L	FINVBL,FINVBL,CHOIXDRUM,CHOIXDRUM,CHOIXFRQ,CHOIXFRQ,CHOIXFRQ,CHOIXFRQ

FUNK_TABLE	DC.B	0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128
		EVEN
RIEN		DS.L	1024/4

TABLE_EFFECT	DC.L	NO_EFFECT,NO_EFFECT,NO_EFFECT,SET_PORTAMENTO_TONE
		DC.L	NO_EFFECT,NO_EFFECT,NO_EFFECT,NO_EFFECT
		DC.L	NO_EFFECT,SAMPLEOFFSET,NO_EFFECT,POS_JUMP
		DC.L	SET_VOLUME,PATT_BREAK,NO_EFFECT,SET_SPEED
		DC.L	NO_EFFECT,FINE_PORT_UP,FINE_PORT_DOWN,SET_GLISSANDO_CONTROL
		DC.L	SET_VIBRATO_CONTROL,SET_FINE_TUNE,JUMP_LOOP,SET_TREMOLO_CONTROL
		DC.L	NO_EFFECT,RETRIG_NOTE,VOLUME_FINE_UP,VOLUME_FINE_DOWN
		DC.L	NOTE_CUTE,NOTE_DELAY,PATTERN_DELAY,FUNK_IT
		
TABLE_EFFECT2	DC.L	ARPEGGIO,PORTAMENTO_UP,PORTAMENTO_DOWN,PORTAMENTO_TONE
		DC.L	VIBRATO,PORT_SLID,VIB_SLID,TREMOLO
		DC.L	NO_EFFECT,NO_EFFECT,VOLUME_SLIDE,NO_EFFECT
		DC.L	NO_EFFECT,NO_EFFECT,NO_EFFECT,NO_EFFECT
		DC.L	NO_EFFECT,NO_EFFECT,NO_EFFECT,NO_EFFECT
		DC.L	NO_EFFECT,NO_EFFECT,NO_EFFECT,NO_EFFECT
		DC.L	NO_EFFECT,RETRIG_NOTE,NO_EFFECT,NO_EFFECT
		DC.L	NOTE_CUTE,NOTE_DELAY,NO_EFFECT,NO_EFFECT

SINUS		DC.B	$00,$18,$31,$4A,$61,$78,$8B,$A1
		DC.B	$B4,$C5,$D4,$E0,$EB,$F4,$FA,$FD
		DC.B	$FA,$F4,$EB,$E0,$D4,$C5,$B4,$A1
		DC.B	$8B,$78,$61,$4A,$31,$18
		
TABLE_DIGINOTE	DC.L	DIGINOTE1,DIGINOTE1,DIGINOTE1,DIGINOTE1
		DC.L	DIGINOTE1,DIGINOTE1,DIGINOTE1,DIGINOTE1
		DC.L	DIGINOTE1,DIGINOTE1,DIGINOTE1,DIGINOTE1
		DC.L	DIGINOTE1,DIGINOTE1,DIGINOTE1,DIGINOTE1
DIGINOTE1
; Tuning 0, Normal
	dc.w	856,808,762,720,678,640,604,570,538,508,480,453 * $358
	dc.w	428,404,381,360,339,320,302,285,269,254,240,226
	dc.w	214,202,190,180,170,160,151,143,135,127,120,113 * $71
	
	dc.w	107,101,095,090,085,080,075,071,067,063,060,056
	dc.w	053,050,047,045,042,040				* $28
; Tuning 1
	dc.w	850,802,757,715,674,637,601,567,535,505,477,450
	dc.w	425,401,379,357,337,318,300,284,268,253,239,225
	dc.w	213,201,189,179,169,159,150,142,134,126,119,113
	dc.w	107,101,095,090,085,080,075,071,067,063,060,056
	dc.w	053,050,047,045,042,040
; Tuning 2
	dc.w	844,796,752,709,670,632,597,563,532,502,474,447
	dc.w	422,398,376,355,335,316,298,282,266,251,237,224
	dc.w	211,199,188,177,167,158,149,141,133,125,118,112
	dc.w	106,100,094,089,084,079,075,071,067,063,059,056
	dc.w	053,050,047,044,042,040
; Tuning 3
	dc.w	838,791,746,704,665,628,592,559,528,498,470,444
	dc.w	419,395,373,352,332,314,296,280,264,249,235,222
	dc.w	209,198,187,176,166,157,148,140,132,125,118,111
	dc.w	105,099,094,088,083,078,074,070,066,063,059,055
	dc.w	053,050,047,045,042,040
; Tuning 4
	dc.w	832,785,741,699,660,623,588,555,524,495,467,441
	dc.w	416,392,370,350,330,312,294,278,262,247,233,220
	dc.w	208,196,185,175,165,156,147,139,131,124,117,110
	dc.w	104,098,092,087,082,078,073,069,065,063,058,055
	dc.w	052,049,046,043,041,039
; Tuning 5
	dc.w	826,779,736,694,655,619,584,551,520,491,463,437
	dc.w	413,390,368,347,328,309,292,276,260,245,232,219
	dc.w	206,195,184,174,164,155,146,138,130,123,116,109
	dc.w	103,097,092,087,082,077,073,069,065,061,058,054
	dc.w	051,048,046,043,041,039
; Tuning 6
	dc.w	820,774,730,689,651,614,580,547,516,487,460,434
	dc.w	410,387,365,345,325,307,290,274,258,244,230,217
	dc.w	205,193,183,172,163,154,145,137,129,122,115,109
	dc.w	102,096,091,086,081,077,072,068,064,061,057,054
	dc.w	051,048,046,043,040,038
; Tuning 7
	dc.w	814,768,725,684,646,610,575,543,513,484,457,431
	dc.w	407,384,363,342,323,305,288,272,256,242,228,216
	dc.w	204,192,181,171,161,152,144,136,128,121,114,108
	dc.w	102,096,090,085,080,076,072,068,064,060,057,054
	dc.w	051,048,045,042,040,038
	
; Tuning -8
	dc.w	907,856,808,762,720,678,640,604,570,538,508,480
	dc.w	453,428,404,381,360,339,320,302,285,269,254,240
	dc.w	226,214,202,190,180,170,160,151,143,135,127,120
	dc.w	113,107,101,095,090,085,080,075,071,067,063,060
	dc.w	056,053,050,047,045,042
; Tuning -7
	dc.w	900,850,802,757,715,675,636,601,567,535,505,477
	dc.w	450,425,401,379,357,337,318,300,284,268,253,238
	dc.w	225,212,200,189,179,169,159,150,142,134,126,119
	dc.w	112,106,100,094,089,084,079,075,071,067,063,059
	dc.w	056,053,050,047,044,042
; Tuning -6
	dc.w	894,844,796,752,709,670,632,597,563,532,502,474
	dc.w	447,422,398,376,355,335,316,298,282,266,251,237
	dc.w	223,211,199,188,177,167,158,149,141,133,125,118
	dc.w	111,105,099,094,088,083,079,074,070,066,062,059
	dc.w	056,053,050,047,044,042
; Tuning -5
	dc.w	887,838,791,746,704,665,628,592,559,528,498,470
	dc.w	444,419,395,373,352,332,314,296,280,264,249,235
	dc.w	222,209,198,187,176,166,157,148,140,132,125,118
	dc.w	111,104,099,093,088,083,078,074,070,066,062,059
	dc.w	056,052,049,047,044,042
; Tuning -4
	dc.w	881,832,785,741,699,660,623,588,555,524,494,467
	dc.w	441,416,392,370,350,330,312,294,278,262,247,233
	dc.w	220,208,196,185,175,165,156,147,139,131,123,117
	dc.w	110,104,098,092,087,082,078,073,069,065,061,058
	dc.w	055,052,049,046,043,041
; Tuning -3
	dc.w	875,826,779,736,694,655,619,584,551,520,491,463
	dc.w	437,413,390,368,347,328,309,292,276,260,245,232
	dc.w	219,206,195,184,174,164,155,146,138,130,123,116
	dc.w	109,103,097,092,087,082,077,073,069,065,061,058
	dc.w	055,051,049,046,043,041
; Tuning -2
	dc.w	868,820,774,730,689,651,614,580,547,516,487,460
	dc.w	434,410,387,365,345,325,307,290,274,258,244,230
	dc.w	217,205,193,183,172,163,154,145,137,129,122,115
	dc.w	108,102,096,091,086,081,077,072,068,064,061,057
	dc.w	054,051,048,046,043,041
; Tuning -1
	dc.w	862,814,768,725,684,646,610,575,543,513,484,457
	dc.w	431,407,384,363,342,323,305,288,272,256,242,228
	dc.w	216,203,192,181,171,161,152,144,136,128,121,114
	dc.w	108,101,099,090,085,080,076,072,068,064,060,057
	dc.w	054,051,048,045,043,040

SNBZIC		EQU	19
SMAXPATT	EQU	20
SCVOIES		EQU	21
STOTALSPL	EQU	22
STOTALYAM	EQU	23
SLENZIC		EQU	24
SLENSEQ		EQU	26
SONEPATT	EQU	28
SLENTABLESPL	EQU	30
SLENTABLEYAM	EQU	32
SADDZIC		EQU	34
SADDSEQ		EQU	38
SLENPATT	EQU	42
SADDPATT	EQU	46
SADDTABLESPL	EQU	50
SADDTABLEYAM	EQU	54
SLENSAMPLES	EQU	58
SLENYAM		EQU	62
SADDSPL		EQU	66

*--------------------------------------------------------------------------
		IFNE	FREQU=12292
FRQ		DC.L	0
		INCBIN	DATA\12292HZ.FRQ
		ENDC
*--------------------------------------------------------------------------

		

		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),4(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),8(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),12(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),16(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),20(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),24(A5)
		RTS


		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,4(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,8(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,12(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,16(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,20(A5)
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,24(A5)
		RTS

*--------------------------------------------------------------------------
		IFNE	FREQU=16490
FRQ		DC.L	0
		INCBIN	DATA\16490HZ.FRQ
		ENDC

		IFNE	FREQU=20770
FRQ		DC.L	0
		INCBIN	DATA\20770HZ.FRQ
		ENDC

		IFNE	FREQU=24585
FRQ		DC.L	0
		INCBIN	DATA\24585HZ.FRQ
		ENDC

		IFNE	FREQU=33880
FRQ		DC.L	0
		INCBIN	DATA\33880HZ.FRQ
		ENDC

		IFNE	FREQU=49170
FRQ		DC.L	0
		INCBIN	DATA\24585HZ.FRQ
		*INCBIN	DATA\49170HZ.FRQ
		ENDC
		

VFRQ2W		MOVE.L	#(502/8)-1,D6
		MOVEQ	#0,D5
BB1		
M		SET	0
		REPT	8
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),M(A5)
M		SET	M+8
		ENDR
		
		LEA	64(A5),A5
		DBF	D6,BB1


		
		IFNE	FREQU=16490
M		SET	0
		REPT	7
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),M(A5)
M		SET	M+4
		ENDR
		ENDC		


		
		IFNE	FREQU=20770
M		SET	0
		REPT	5
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),M(A5)
M		SET	M+4
		ENDR
		ENDC
		
		
		
		IFNE	(FREQU=33880)!(FREQU=24585)
M		SET	0
		REPT	6
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),M(A5)
M		SET	M+4
		ENDR
		ENDC


		
		IFNE	FREQU=49170
M		SET	0
		REPT	6
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),M(A5)
M		SET	M+8
		ENDR
		ENDC
		RTS
		
*--------------------------------------------------------------------------
VFRQ3W		bra	VFRQ2W
		
		MOVE.L	#(VAL/8)-1,D6
		MOVEQ	#0,D5
BB2		
M		SET	0
		REPT	8
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,M(A5)
M		SET	M+4
		ENDR
		
		LEA	32(A5),A5
		DBF	D6,BB2



		IFNE	FREQU=16490
M		SET	0
		REPT	7
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,M(A5)
M		SET	M+4
		ENDR
		ENDC



		IFNE	FREQU=24770
M		SET	0
		REPT	5
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,M(A5)
M		SET	M+4
		ENDR
		ENDC
		
		
		
		IFNE	(FREQU=33880)!(FREQU=24585)
M		SET	0
		REPT	6
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,M(A5)
M		SET	M+4
		ENDR
		ENDC		


		
		IFNE	FREQU=49170
M		SET	0
		REPT	4
		SUB.W	D0,D1
		ADDX.W	D2,D3
		MOVE.B	(A0,D3.W),D5
		MOVE.W	(A4,D5.W*2),D4
		ADD.W	D4,M(A5)
M		SET	M+4
		ENDR
		ENDC
		RTS		
		
FRQ1W
FRQ2W
FRQ3W
VFRQ1W
FRQ1L
FRQ2L
FRQ3L
VFRQ1L
VFRQ2L
VFRQ3L
D625R25
D625R125
D625R625
D125R625
D625R25_ADD
D625R125_ADD
D625R625_ADD
D125R625_ADD
D625R25_VOL
D625R125_VOL
D625R625_VOL
D125R625_VOL
D625R25_VOL_ADD
D625R125_VOL_ADD
D625R625_VOL_ADD
D125R625_VOL_ADD
	RTS		
		
CMOD		LEA	VOLUME(PC),A1
		ADD.L	#33808,A1
		LEA	ADDMOD(PC),A0
		MOVE.L	A1,(A0)
		RTS
		
VOLUME		INCBIN	DATA\16_BIT
MOD		INCBIN	painaway.MOD

endtext
	